
pVelocity = Allocate(2) ;
pAge = Allocate(1) ; 
pSpin = Allocate(1); 
pSpinSpeed = Allocate(1);
pRadius = Allocate(1);


SetTexture("bubble");
SetBlendMode(kBlendAdditiveAlpha);
SetNumParticles(6);

if not dLocus then
   dLocus= Vec2(0,0) ; 
end

pRadius:Init( fRange(0,2) );
pPosition:Init( Vec2(0,0));

pVelocity:Init( fRange( Vec2(-10,10), Vec2(10,-10) ) );

pScale:Init(fRange(0,0.5));

pAge:Init(0);

pSpin:Init( fRange( 0, 2*3.1415927 ) );
pSpinSpeed:Init( fRange( -30, 30 ) );

pPosition:Anim( pPosition+f2dRotation(pSpin)+ fTimeScale(pVelocity));

pScale:Anim( pScale + fTimeScale(0.1) );

pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,-100)) );
pColor:Anim( 
   fFade( pAge,
     Color(0.1,0.1,1,1), 500, 
     Color(1,1,1,1), 800, 
     Color(1,0.1,0.1,1),1000, 
     Color(1,1,1,0) ) 
   );

pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
pUp:Anim( f2dRotation( pSpin ) );

pAge:Anim( pAge+fAge() );

Anim( fExpire( fGreater(pAge,2600) ) );


-- A global variable that we can set from C++
--grow = true

function Update(seconds)
   if grow then      
      CreateParticles( 6 );
   end
grow = false;
end

